﻿<?xml version="1.0" ?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:feed="http://www.w3.org/2005/Atom"
				xmlns:frc="http://www.feedreader.com/ns/3.0/frc"
				xmlns:fr="http://www.feedreader.com/ns/3.0"
				version="1.0">
<xsl:output method="html" />

<xsl:template match="/">

<html>
  <head>
    <title><xsl:value-of select="/feed:feed/feed:title"/></title>
    <link rel="stylesheet" href="atom.css"/>
    <style>

body {
 font-family: verdana, tahoma;
 font-size: 0.7em;
 line-height: 1.3em;
 padding: 0;
 margin: 0;
}


a, a:link, a:active, a:visited {
 text-decoration: none;
 color: #0088ff;
}

div.entry {
 padding: 0 20px 20px 25px;
 border-bottom: 1px solid #ddd;
}

div.content img {
}

div.active {
 background-color: #f1f5fa;;
}

.read .title a {
 color: #aaa;
}


.read .content {
 color: #555;
}

div.entry .read .title a {
 color: gray;
}

.header {
 padding-top: 20px;
 margin: 0 0 0.2em 0;
}

.title {
 font-size: 1.6em;
 font-family: arial, verdana, tahoma;
 font-weight: bold;
 letter-spacing: -1px;
 line-height: 1.1em;
}

div.details {
 color: gray;
 margin-bottom: 0.5em;
}
div.clear {
 clear:both;
 height: 1px;
 width: 1px;
 font-size: 1px;
 line-height: 1px;
}
span.modified, span.author, span.category {
}

.status a {
 display:block;
 line-height: 0;
 font-size: 0;
 width: 8px; 
 height: 8px;
 margin-top: -1.5em;
 background-image: url('<xsl:value-of select="/feed:feed/fr:imagebase"/>stylesheet/unread_8x8.png');
 background-repeat: no-repeat;
}

.read .status a {
 background-image: url('<xsl:value-of select="/feed:feed/fr:imagebase"/>stylesheet/read_8x8.png');
}






</style>
<base>    
<xsl:attribute name="href"><xsl:value-of select="/feed:feed/feed:entry/feed:source/feed:link[@rel='alternate'][1]/@href"/>/</xsl:attribute>
</base> 
  </head>	
  <body>
  <script type="text/javascript">
  var imagebase='file://<xsl:value-of select="/feed:feed/fr:imagebase"/>';
  </script>
  <xsl:apply-templates select="feed:feed"/>
  </body>
</html>
</xsl:template>

<xsl:template match="feed:feed">
  <xsl:apply-templates select="feed:entry"/>
</xsl:template>

<xsl:template match="feed:entry">

	<div class="entry">
		<xsl:attribute name="id">article<xsl:value-of select="fr:item_id"/></xsl:attribute>
		<xsl:if test="fr:rtlEnabled = 1">
			<xsl:attribute name="style">direction:RTL;font-size: 1.1em;font-family: tahoma;</xsl:attribute>
		</xsl:if>
		<xsl:if test="fr:status = 1">
			<xsl:attribute name="class">entry read</xsl:attribute>
		</xsl:if>
				
		<div class="header">

		<span class="title">
		<xsl:choose>
                <xsl:when test="string-length(feed:link/@href)>0">
	  		<a>
			<xsl:attribute name="href"><xsl:value-of select="feed:link/@href"/></xsl:attribute>
			<xsl:value-of select="feed:title"/>
			</a>
                </xsl:when>
                <xsl:otherwise>
			<xsl:value-of select="feed:title"/>
                </xsl:otherwise>
                 </xsl:choose>
		</span>

		  <span class="status">
		  <xsl:attribute name="style">float:right;</xsl:attribute>
	      <xsl:if test="fr:rtlEnabled = 1">
	    	<xsl:attribute name="style">float:left;</xsl:attribute>
		  </xsl:if>
	      <xsl:if test="fr:rtlEnabled != 1">
	    	<xsl:attribute name="style">float:right;</xsl:attribute>
		  </xsl:if>
		  
		  <a>
	   	  
		  <xsl:attribute name="id">togglelink<xsl:value-of select="fr:item_id"/></xsl:attribute>
		    <xsl:attribute name="href">fr:toggleread/<xsl:value-of select="fr:item_id"/></xsl:attribute>
		  <xsl:attribute name="onclick">this.blur();</xsl:attribute>
                   
		  </a>
		  </span>
		</div>
	
                <div class="details">
		 	<span class="updated"><xsl:value-of select="fr:updated"/>, </span>		
			<xsl:if test="feed:author"> 
	  			<span class="author">
				<xsl:apply-templates select="feed:author"/>
				</span>
			</xsl:if>
			<a>
			<xsl:attribute name="href">fr:edittags/<xsl:value-of select="fr:item_id"/></xsl:attribute>

			<img>
			<xsl:attribute name="border">0</xsl:attribute>
			<xsl:attribute name="hspace">5</xsl:attribute>
			<xsl:attribute name="src">file://<xsl:value-of select="/feed:feed/fr:imagebase"/>stylesheet/tag_edit.png</xsl:attribute>
			</img>
			</a>
                        
			<xsl:if test="feed:category">
			  	<span class="category"> 
  				<xsl:apply-templates select="feed:category"/>
				</span>
                	</xsl:if>
			<xsl:if test="feed:source">
			  	<span class="source"> 
				<a>
				<xsl:attribute name="href">fr:feed/<xsl:value-of select="feed:source/fr:feed_id"/></xsl:attribute>
				<xsl:value-of select="feed:source/feed:title"/>
				</a>
				<a>
				<xsl:attribute name="href">
				<!-- <xsl:for-each select = "feed:source/feed:link[@rel='alternate']"> --> 
    				<xsl:value-of select = "feed:source/feed:link[@rel='alternate'][1]/@href"/> 
    				<!-- </xsl:for-each> -->
				</xsl:attribute>
                      
			<img>
			<xsl:attribute name="border">0</xsl:attribute>
			<xsl:attribute name="hspace">5</xsl:attribute>
			<xsl:attribute name="src">file://<xsl:value-of select="/feed:feed/fr:imagebase"/>stylesheet/world_go.png</xsl:attribute>
			</img>
				</a>                                  
				</span>
                                
                	</xsl:if>
		</div>
	<xsl:if test="frc:comments">
                <div class="details">
			<a>
			<xsl:attribute name="href"><xsl:value-of select="frc:comments"/></xsl:attribute>
			Read comments
			</a>
			
		</div>
	</xsl:if>
	<xsl:if test="feed:content">
		<div class="content">
			<xsl:value-of disable-output-escaping="yes" select="feed:content"/>
		</div>
	</xsl:if>
	<div class="clear" />
	</div>

</xsl:template>

<xsl:template match="feed:category">
  <a>
  <xsl:attribute name="href">fr:<xsl:value-of select="./@scheme"/></xsl:attribute>
  <xsl:value-of select="./@term"/>
  </a>, 
</xsl:template>

<xsl:template match="feed:author">
  <xsl:value-of select="feed:name"/>, 
</xsl:template>

</xsl:stylesheet>
